<?php $__env->startSection('title', 'Blog Posts'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Blog Posts</h1>
    <a href="<?php echo e(route('admin.blogs.create')); ?>" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Add New Post
    </a>
</div>

<div class="card">
    <div class="card-body">
        <?php if($blogs->count() > 0): ?>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Featured Image</th>
                        <th>Title</th>
                        <th>Author</th>
                        <th>Published</th>
                        <th>Views</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <?php if($blog->featured_image): ?>
                                <img src="<?php echo e(asset('storage/' . $blog->featured_image)); ?>" alt="<?php echo e($blog->title); ?>" style="width: 60px; height: 60px; object-fit: cover; border-radius: 4px;">
                            <?php else: ?>
                                <i class="bi bi-image" style="font-size: 2rem; color: #ccc;"></i>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($blog->title); ?></td>
                        <td><?php echo e($blog->author ?? 'Admin'); ?></td>
                        <td><?php echo e($blog->published_at ? $blog->published_at->format('M d, Y') : 'Not set'); ?></td>
                        <td><?php echo e($blog->views); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($blog->is_published ? 'success' : 'secondary'); ?>">
                                <?php echo e($blog->is_published ? 'Published' : 'Draft'); ?>

                            </span>
                        </td>
                        <td>
                            <a href="<?php echo e(route('admin.blogs.show', $blog)); ?>" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                            <a href="<?php echo e(route('admin.blogs.edit', $blog)); ?>" class="btn btn-sm btn-warning">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <form action="<?php echo e(route('admin.blogs.destroy', $blog)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this blog post?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
        <p class="text-muted mb-0">No blog posts yet. <a href="<?php echo e(route('admin.blogs.create')); ?>">Create your first post</a>.</p>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/sumankc/Desktop/ENT Care/resources/views/admin/blogs/index.blade.php ENDPATH**/ ?>